%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% MATLAB code: Exercise 12.2
% File: Rtest.m 
%
% Purpose: To apply nonlinear vector time series lag 
% identification by the R test statistic to a given data set.
%
% Converted from FORTRAN90 code written by Jane L. Harvill.
% INPUT:  data = A BIVARIATE TIME SERIES of size (nr * nc=2)
% OUTPUT: rrr  = values of R_{i,j}(\ell) test statistic 
%                for \ell=1,...,nlag, i,j=1,...,nc, i.e.
%                two matrices of size (nlag * nc=2)                   
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
[nr, nc] = size(data);
in       =  30;    % 30-point Gaussian quadrature rule
nlag     =   5;    % Number of lags
x        = data;      
rrr      = compr(nr,nlag,nc,x,in);   

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%  SUBFUNCTIONS
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [x,w]=lgwt(N,a,b)
% This script is for computing definite integrals using Legendre-Gauss 
% Quadrature. Computes the Legendre-Gauss nodes and weights on an 
% interval [a,b] with truncation order N.
% Suppose you have a continuous function f(x) which is defined on [a,b]
% which you can evaluate at any x in [a,b]. Simply evaluate it at all 
% of the values contained in the x vector to obtain a vector f. Then 
% compute the definite integral using sum(f.*w);
%
% Written by Greg von Winckel - 02/25/2004
N  = N-1;
N1 = N+1; N2 = N+2;
xu = linspace(-1,1,N1)';
% Initial guess
y = cos((2*(0:N)'+1)*pi/(2*N+2))+(0.27/N1)*sin(pi*xu*N/N2);
% Legendre-Gauss Vandermonde Matrix
L = zeros(N1,N2);
% Derivative of LGVM
Lp = zeros(N1,N2);
% Compute the zeros of the N+1 Legendre polynomial
% using the recursion relation and the Newton-Raphson method
y0 = 2;
% Iterate until new points are uniformly within epsilon of old points
while max(abs(y-y0))>eps       
    L(:,1)  = 1;
    Lp(:,1) = 0;   
    L(:,2)  = y;
    Lp(:,2) = 1;
    for k=2:N1
        L(:,k+1) = ((2*k-1)*y.*L(:,k)-(k-1)*L(:,k-1))/k;
    end
    Lp = (N2)*(L(:,N1)-y.*L(:,N2))./(1-y.^2);   
    y0 = y;
    y  = y0-L(:,N2)./Lp;    
end

% Linear map from[-1,1] to [a,b]
x = (a*(1-y)+b*(1+y))/2;      
% Compute the weights
w = (b-a)./((1-y.^2).*Lp.^2)*(N2/N1)^2;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function f = kuniv(n,x,xt)     % Estimate of univariate density
hx = 0.85*n^(-1/5);            % Bandwidth
f  = 0;
for i=1:n
   f = f+tpdf((x-xt(i))/hx,4); % Univ. Student t density with df=4 
end     
f = f/(n*hx);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function r = compr(n,nlag,k,x,in)
prod = x.*x;
sum1 = sum(x(:,1:2))/n;
sigx = sum(prod(:,1:2)); 
for i=1:k
   sigx(i) = ((sigx(i)-n*sum1(i)^2)/(n-1))^(0.5);
end
for i=1:nlag
   for j=1:k
     for l=1:k
        for m=1:n-i
          xt(m) = (x(m+i,j)- sum1(j))/sigx(j);
          yt(m) = (x(m,l)  - sum1(l))/sigx(l);
        end
        [rho,deltai] = hbivar2(in,n-i,xt,yt);        
        r(i,j,l)     = deltai;
        rt(i,j,l)    = rho;
        if (deltai < 0) 
          deltai = 0;
        end
        r(i,j,l) = (1.0-exp(-2*deltai))^(0.5); % R(\ell) test statistic
    end    
  end
end
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [rho,h] = hbivar2(in,n,xt,yt)
rho   = sum(xt.*yt)/n;
xlow1 = min(xt); 
xupp1 = max(xt);
xlow2 = min(yt); 
xupp2 = max(yt); 

[qx,qwx] = lgwt(in,-1,1);
for i=1:in
   tempx = -qx(i)*(xupp1-xlow1+2)/2+(xupp1+xlow1)/2;
   tempy = -qx(i)*(xupp2-xlow2+2)/2+(xupp2+xlow2)/2;
   fx(i) = kuniv(n,tempx,xt);
   fy(i) = kuniv(n,tempy,yt);
end
h = 0;
for i=1:in
   for j=1:in
     tempx = -qx(i)*(xupp1-xlow1+2)/2+(xupp1+xlow1)/2;
     tempy = -qx(j)*(xupp2-xlow2+2)/2+(xupp2+xlow2)/2;
     f = kbivar(n,tempx,tempy,xt,yt,rho);
     h = h+(log(f)-log(fx(i))-log(fy(j)))*f*qwx(i)*qwx(j);
   end
end
   h = h*(xupp1-xlow1+2)*(xupp2-xlow2+2)/4;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function f = kbivar(n,x,y,xt,yt,rho);  % Estimate of bivariate density
% Product kernel of Student's t distributions with bandwidth:
hx = (0.85*(1-(rho^2))^(5/12))*(1+0.5*(rho^2))^(-1/6)*n^(-1/6);
hy = hx;
f  = 0;
for i=1:n
   f = f+tpdf((x-xt(i))/hx,4)*tpdf((y-yt(i))/hy,4); 
end
f = f/(n*hx*hy);
